/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.jmx;

import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.h14199.command.Command;
import org.h14199.engine.ConnectionInfo;
import org.h14199.engine.Constants;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.jmx.DatabaseInfoMBean;
import org.h14199.jmx.DocumentedMBean;
import org.h14199.store.PageStore;
import org.h14199.table.Table;

public class DatabaseInfo
implements DatabaseInfoMBean {
    private static final Map<String, ObjectName> MBEANS = new HashMap<String, ObjectName>();
    private final Database database;

    private DatabaseInfo(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' must not be null");
        }
        this.database = database;
    }

    private static ObjectName getObjectName(String string, String string2) throws JMException {
        string = string.replace(':', '_');
        string2 = string2.replace(':', '_');
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("name", string);
        hashtable.put("path", string2);
        return new ObjectName("org.h14199", hashtable);
    }

    public static void registerMBean(ConnectionInfo connectionInfo, Database database) throws JMException {
        String string = connectionInfo.getName();
        if (!MBEANS.containsKey(string)) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            String string2 = database.getShortName();
            ObjectName objectName = DatabaseInfo.getObjectName(string2, string);
            MBEANS.put(string, objectName);
            DatabaseInfo databaseInfo = new DatabaseInfo(database);
            DocumentedMBean documentedMBean = new DocumentedMBean(databaseInfo, DatabaseInfoMBean.class);
            mBeanServer.registerMBean(documentedMBean, objectName);
        }
    }

    public static void unregisterMBean(String string) throws Exception {
        ObjectName objectName = MBEANS.remove(string);
        if (objectName != null) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(objectName);
        }
    }

    @Override
    public boolean isExclusive() {
        return this.database.getExclusiveSession() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public String getMode() {
        return this.database.getMode().getName();
    }

    @Override
    public boolean isMultiThreaded() {
        return this.database.isMultiThreaded();
    }

    @Override
    @Deprecated
    public boolean isMvcc() {
        return this.database.isMVStore();
    }

    @Override
    public int getLogMode() {
        return this.database.getLogMode();
    }

    @Override
    public void setLogMode(int n) {
        this.database.setLogMode(n);
    }

    @Override
    public int getTraceLevel() {
        return this.database.getTraceSystem().getLevelFile();
    }

    @Override
    public void setTraceLevel(int n) {
        this.database.getTraceSystem().setLevelFile(n);
    }

    @Override
    public long getFileWriteCountTotal() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getWriteCountTotal();
        }
        return 0L;
    }

    @Override
    public long getFileWriteCount() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getWriteCount();
        }
        return this.database.getStore().getMvStore().getFileStore().getReadCount();
    }

    @Override
    public long getFileReadCount() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getReadCount();
        }
        return this.database.getStore().getMvStore().getFileStore().getReadCount();
    }

    @Override
    public long getFileSize() {
        if (!this.database.isPersistent()) {
            return 0L;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getPageCount() * pageStore.getPageSize() / 1024;
        }
        return this.database.getStore().getMvStore().getFileStore().size();
    }

    @Override
    public int getCacheSizeMax() {
        if (!this.database.isPersistent()) {
            return 0;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getCache().getMaxMemory();
        }
        return this.database.getStore().getMvStore().getCacheSize() * 1024;
    }

    @Override
    public void setCacheSizeMax(int n) {
        if (this.database.isPersistent()) {
            this.database.setCacheSize(n);
        }
    }

    @Override
    public int getCacheSize() {
        if (!this.database.isPersistent()) {
            return 0;
        }
        PageStore pageStore = this.database.getPageStore();
        if (pageStore != null) {
            return pageStore.getCache().getMemory();
        }
        return this.database.getStore().getMvStore().getCacheSizeUsed() * 1024;
    }

    @Override
    public String getVersion() {
        return Constants.getFullVersion();
    }

    @Override
    public String listSettings() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.database.getSettings().getSettings()).entrySet()) {
            stringBuilder.append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public String listSessions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : this.database.getSessions(false)) {
            Table[] tableArray;
            stringBuilder.append("session id: ").append(session.getId());
            stringBuilder.append(" user: ").append(session.getUser().getName()).append('\n');
            stringBuilder.append("connected: ").append(new Timestamp(session.getSessionStart())).append('\n');
            Command command = session.getCurrentCommand();
            if (command != null) {
                stringBuilder.append("statement: ").append(command).append('\n').append("started: ").append(session.getCurrentCommandStart().getString()).append('\n');
            }
            if ((tableArray = session.getLocks()).length > 0) {
                for (Table table : session.getLocks()) {
                    if (table.isLockedExclusivelyBy(session)) {
                        stringBuilder.append("write lock on ");
                    } else {
                        stringBuilder.append("read lock on ");
                    }
                    stringBuilder.append(table.getSchema().getName()).append('.').append(table.getName()).append('\n');
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

